﻿//////////////////////////////////////////////
// SimdInformation.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Enums ------------------------------------

namespace nkDebug
{
	enum class SIMD_VERSION
	{
		NO_SUPPORT = 0,
		SSE,
		SSE_2,
		SSE_3,
		SSE_4_1,
		SSE_4_2
	} ;

	enum class AVX_VERSION
	{
		NO_SUPPORT = 0,
		AVX,
		AVX_2
	} ;
}

/// Structs ----------------------------------

namespace nkDebug
{
	struct SimdInformation final
	{
		SIMD_VERSION _sseMinimalVersion = SIMD_VERSION::NO_SUPPORT ;
		AVX_VERSION _avxMinimalVersion = AVX_VERSION::NO_SUPPORT ;
	} ;
}